<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Project;
use App\Project_Detail;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except(['index', 'increaseProjects', 'decreaseProjects']);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $projects =  Project::take(6)->orderBy('id', 'desc')->get();
        $total_projects = Project::all();
        return view('home', ['projects' => $projects, 'total_projects' => count($total_projects)]);
    }

    public function increaseProjects($count)
    {
        $projects =  Project::take($count)->orderBy('id', 'desc')->get();
        $all_projects= Project::all();
        return response()->json([
            'projects' => $projects,
            'total_projects' => count($all_projects)
        ]);
    }

    public function decreaseProjects($count)
    {
        $projects =  Project::take($count)->orderBy('id', 'desc')->get();
        $all_projects= Project::all();
        return response()->json([
            'projects' => $projects,
            'total_projects' => count($all_projects)
        ]);
    }

}
