<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Project_Detail;
use App\Project;

class ProjectDetailController extends Controller
{
    public function add(Request $request, $id){
        if(Auth::check()){
            $validator =  Validator::make($request->all(),
            [
                'editprojectdetailimage' => 'required',
                'editprojectdetailimage.*' => 'mimes:jpg,jpeg,jpe,jiff,jif,jfif,png'
            ],
            [
                'editprojectdetailimage.required'=> 'Please upload the project\'s detail images.',
                'editprojectdetailimage.*.mimes'=> 'The project\'s detail images must be a file of type: jpg, jpeg, jpe, jiff, jif, jfif, png. Please upload the project\'s detail images again.'
            ]);

            if($validator->fails()){
                $detail=Project_Detail::select()->where('project_id', $id)->get();
                return back()->withErrors($validator)->withInput()->with('failed_add_editprojectdetailimage', 'failed_add_editprojectdetailimage')->with('editprojectdetailimage', $detail);
            }

            if($request->has('editprojectdetailimage')){
                foreach($request->file('editprojectdetailimage') as $file){
                    $project_detail_image_file = time().'_'.$file->getClientOriginalName();
                    $file->move(\public_path('uploads\projects_detail'), $project_detail_image_file);
                    $project_detail = new Project_Detail();
                    $project_detail->project_id = $id;
                    $project_detail->project_detail_images = $project_detail_image_file;
                    $project_detail->save();
                }                      
            }
            $detail1=Project_Detail::select()->where('project_id', $id)->get();
            $project_count= $request->editprojectcount1;
            return redirect()->back()->withInput()->with("detail_message", "The new detail images of the project is saved successfully!!")->with('editprojectcount', $project_count)->with('editprojectdetailimage', $detail1);
        }
        return redirect('/');
    }

    public function delete($id, $project_id){
        if(Auth::check()){
            Project_Detail::where('project_detail_id', $id)->delete();
            $projects = Project::find($project_id);
            $projects_detail = Project_Detail::select()->where('project_id', $project_id)->get();
            return response()->json([
                'projects' => $projects, 
                'projects_detail' => $projects_detail
            ]);
        }
        return redirect('/');
    }
}
