<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\User;

class UserController extends Controller
{
    public function update(Request $request){
        if(Auth::check()){

            $validator = Validator::make($request->all(), [
                'username'=> 'required|max:30',
                'useremail' => 'required|email'
                ], [
                'required' => 'Please enter your :attribute.'
                ], [
               'username' => 'name',
               'useremail' => 'email',
            ]);

            if($validator->fails()){
                return back()->withErrors($validator)->withInput()->with('user_update_failed', 'yyy');
            }

            $user_id = Auth::user()->id;

            $user = User::find($user_id);
            $user->name = $request->username;
            $user->email = $request->useremail;
            $user->save();

            Auth::user()->name = $user->name;
            return redirect()->back()->with('message','Your profile is updated successfully!');
        }
        else{
            return redirect('/');
        }
    }

    public function updatePassword(Request $request){
        $validator = Validator::make($request->all(),
        [
            'userpassword' => 'required',
            'newpassoword' => 'required|min:6',
            'confirmpassoword' => 'required|same:newpassoword'
        ],
        [ 
            'required' => 'Please enter :attribute.' 
        ],
        [ 
            'userpassword' => 'current password',
            'newpassoword' => 'new password',
            'confirmpassoword' => 'confiremd passsword'
        ]);

        if($validator->fails()){
            return back()->withErrors($validator)->withInput()->with('user_password_update_failed', 'yyy');
        }

        $user_id = Auth::user()->id;

        $user = User::find($user_id);

        if(!Hash::check($request->userpassword, $user->password)){
            return back()->withInput()->with('wrong_password', 'Your current password is wrong.');
        }

        $user->password = Hash::make($request->newpassoword);
        $user->save();

        return redirect()->back()->with('message','Your password is changed successfully!');
    }
}
