$(document).ready(function(){
    $('#addNewProject #btnAddProject').on('click', function(){
        $('#addNewProject #projectmainimage-error, #addNewProject #projectdetailimage-error').remove();
        
        $('#addNewProject #formAddProject').validate({
            rules: {
                "projectname": {
                    required: true,
                    maxlength: 30
                },
                "projectlocation": {
                    maxlength: 20,
                    required: true
                },
                "projectmainimage": {
                    required: true,
                    extension: "jpg|jpeg|jpe|jiff|jif|jfif|png"
                },
                "projectdetailimage": {
                    required: false,
                    extension: "jpg|jpeg|jpe|jiff|jif|jfif|png"
                }
            },
            messages: {
                "projectname": {
                    required: "Please enter the project's name.",
                    maxlength: "The project's name must not be more than 30 characters."
                },
                "projectlocation": {
                    required: "Please enter the project's location.",
                    maxlength: "The project's location must not be more than 20 characters."
                },
                "projectmainimage": {
                    required: "Please choose the project's main image.",
                    extension: "The project's main image must be the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png."
                },
                "projectdetailimage": {
                    extension: "The project's detail images must be the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png."
                }
            },
            errorPlacement: function(error, element){
                if($(element).attr('type') == "file"){
                    error.appendTo(element.parents('.form-group').before());
                }
                else{
                    error.insertAfter(element);
                }                            
            },
            highlight: function(element){
                if($(element).attr('type') == "file"){
                    $(element).parents('.form-group').attr('style', 'margin-bottom:16px;'); 
                }
                else{
                    $(element).addClass('input-validation-error');
                    $(element).parents('.form-group').attr('style', 'margin-bottom:9px;'); 
                }
            },
            unhighlight: function(element){
                $(element).removeClass('input-validation-error');
                $(element).parents('.form-group').removeAttr('style');
            }
        });
    });

    $('#addNewProject .close').click(function () {
        location.reload(true);
    });

     // For Laravel Error
     $("#addNewProject #formAddProject .form-input-error").each(function() {       
        if($(this).children().hasClass('error')) { 
            if( $(this).parents('.form-group').find('.form-control').attr('type') == "file"){
                $(this).parents('.form-group').attr('style', 'margin-bottom:16px;'); 
                $(this).attr('style', 'margin-top:4px;'); 
            } 
            else{
                $(this).parents('.form-group').find('.form-control').addClass('input-validation-error');    
                $(this).parents('.form-group').attr('style', 'margin-bottom:10px;'); 
                $(this).attr('style', 'margin-top:4px;'); 
            }
        } 
        else{
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
        } 
    });

});