$(document).ready(function(){
    $('#btnEditProfile').on('click', function(){
        $('#formProfileSetting').validate({
            rules: {
                "username": {
                    required: true,
                    maxlength: 30
                },
                "useremail": {
                    required: true,
                    checkEmail: true
                }
            },
            messages: {
                "username": {
                    required: "Please enter your name.",
                    maxlength: "Your name must not be more than 30 characters."
                },
                "useremail": {
                    required: "Please enter your email.",
                    checkEmail: "Please enter a valid email address."
                }
            },
            errorPlacement: function(error, element){
                error.insertAfter(element);                            
            },
            highlight: function(element){
                $(element).addClass('input-validation-error');
                $(element).parents('.form-group').attr('style', 'margin-bottom:9px;'); 
                $(element).attr('style', 'margin-top:4px;');
            },
            unhighlight: function(element){
                $(element).removeClass('input-validation-error');
                $(element).parents('.form-group').removeAttr('style');
                $(element).removeAttr('style');
            }
        });
    });

    $.validator.addMethod("checkEmail", function(value, element){
        return /^[\w -.]+@[\w -.]+\.\w{2,}$/.test(value);
    }, "Invalid email address!!!");

    $('#btnChangePass').on('click', function(){
        $('#profileSettings').modal('hide');
        $('#profileSettings .form-control').val('');
        $("#profileSettings #formProfileSetting .form-input-error").each(function() {
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
            $(this).empty();
        });
        $("#profileSettings #formProfileSetting .error").each(function(){
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error').removeAttr('aria-invalid');
            $(this).parents('.form-group').removeAttr('style');
            $(this).parents('.form-group').find('.form-control').removeAttr('style');
            $(this).remove();
        });
    });

    $('#profileSettings .close').on('click', function () {
        $('#profileSettings .form-control').val('');
        $("#profileSettings #formProfileSetting .form-input-error").each(function() {
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
            $(this).empty();
        });
        $("#profileSettings #formProfileSetting .error").each(function(){
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error').removeAttr('aria-invalid');
            $(this).parents('.form-group').find('.form-control').removeAttr('style');
            $(this).parents('.form-group').removeAttr('style');
            $(this).remove();
        });
    });

    // For Laravel Error
    $("#formProfileSetting .form-input-error").each(function() {       
        if($(this).children().hasClass('error')) {  
            $(this).parents('.form-group').find('.form-control').addClass('input-validation-error');    
            $(this).parents('.form-group').attr('style', 'margin-bottom:10px;'); 
            $(this).attr('style', 'margin-top:4px;'); 
        } 
        else{
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
        } 
    });
});