<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to RKMK</title>
    <link rel="icon" type="image/png" href="{{ url('images/Royal KMK (Logo).png') }}"/>

    <!-- css -->
    <link rel="stylesheet" href="{{ asset('css/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('css/responsive.css') }}"/>
    <link rel="stylesheet" href="{{ asset('bootstrap/dist/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('css/loading.css') }}"/>

    <!-- animation css -->
    <link rel="stylesheet" href="{{ asset('css/animate.css') }}"/>

    <!-- jquery -->
    <script type="text/javascript" src="{{ asset('jquery-3.5.1/dist/jquery.min.js') }}"></script>

    <!-- javascript -->
    <script type="text/javascript" src="{{ asset('bootstrap/dist/js/bootstrap.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/main.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/imageLightBox.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/FousInputControl.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/PreviewImage.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/loading.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/passwordToggle.js') }}"></script>

    <!-- JQuery Validation -->
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>
    <script type="text/javascript" src="{{ asset('javascript/ContactValidation.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/ProfileSettingsValidation.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/AddingProjectValidation.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/EditingProjectValidation.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/DeletingProjectValidation.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/ChangePasswordValidation.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/Increasing&DecreasingProject.js') }}"></script>

    <!-- font -->
    <!-- <link href="https://fonts.googleapis.com/css2?family=Frank+Ruhl+Libre:wght@300&display=swap" rel="stylesheet"> -->
    <link href="https://fonts.googleapis.com/css2?family=Cabin&display=swap" rel="stylesheet">

    <!-- font awesome -->
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.css') }}"/>

    <!-- For Body -->
    <style>
        body {
            padding:0;
            margin:0;
            font-family: 'Frank Ruhl Libre', serif;
            color:#333;
            background-color:#f6f6f6;
        }
    </style>

    @auth
    <script type="text/javascript">
        $(document).ready(function(){
            $('[data-target="#profileSettings"]').on('click', function(){
                $('#formProfileSetting #userid').val('{{Auth::user()->id}}');
                $('#formProfileSetting #username1').val('{{Auth::user()->name}}');
                $('#formProfileSetting #useremail').val('{{Auth::user()->email}}');
                $('#formProfileSetting #registereddate').val('{{ Auth::user()->created_at->format('d M Y') }}');
            });
        });
    </script>
    @endauth

</head>
<body>
    {{-- User --}}
    @if( session('user_update_failed') )
        <script type="text/javascript">
            $(document).ready(function(){
                $('#profileSettings').modal();
            });
        </script>
    @endif

    @if( session('user_password_update_failed') || session('wrong_password') )
        <script type="text/javascript">
            $(document).ready(function(){
                $('#changePassword').modal();
            });
        </script>
    @endif
    
    {{-- Projects --}}
    @if( session('failed_add_project') )
    <script type="text/javascript">
        $(document).ready(function(){
            $('#addNewProject').modal();
        });
    </script>
    @endif

    @if( session('failed_update_project') )
    <script type="text/javascript">
        $(document).ready(function(){
            $('#editProject').modal();
            $('#editProject #formEditProject').attr('action', '/updateProjects/'+ $('#editprojectid').val() );
            $('#editProject #formAddNewDetailImages').attr('action', '/addNewDetailImages/'+ $('#editprojectid').val());
            var a = "{{ session('failed_update_project') }}";
            
            if(a == "update_failed"){
                $('#editProject #editpreviewImage').empty();
            }
            else{
                var preview_project_image = "<div class=\"row text-center mb-1\">"+
                                        "<div class=\"col-4 my-2\">"+
                                        "<img src=\"/uploads/projects/"+ a + "\" style=\"max-width: 100%; width: auto; height: 100px;\"/>"+
                                        "</div>"+
                                    "</div>";
                $('#editProject #editpreviewImage').html(preview_project_image);
            }
        });
    </script>
    @endif

    @if( session('failed_add_editprojectdetailimage') )
    <script type="text/javascript">
        $(document).ready(function(){
            $('#editProject').modal();
            $('#editProject #formEditProject').attr('action', '/updateProjects/'+ $('#editprojectid1').val());
            $('#editProject #formAddNewDetailImages').attr('action', '/addNewDetailImages/'+ $('#editprojectid1').val());
            $('#editprojectname').val($('#editprojectname1').val());
            $('#editprojectlocation').val($('#editprojectlocation1').val());
            var preview_project_image = "<div class=\"row text-center mb-1\">"+
                                        "<div class=\"col-4 my-2\">"+
                                        "<img src=\"/uploads/projects/"+ $('#editprojectmainimage1').val() + "\" style=\"max-width: 100%; width: auto; height: 100px;\"/>"+
                                        "</div>"+
                                    "</div>";
            $('#editpreviewImage').html(preview_project_image);

        });
    </script>
    @endif

    @if( session('detail_message') )
    <script type="text/javascript">
        $(document).ready(function(){

            $('#content').show();
            $('#loading').hide();

            alert('{{ session('detail_message') }}');

            var count= {{ session('editprojectcount') }};
            var m = 6;

            $.get('increaseProjects/' + count, function(data){
                var html = "";
                
                $.each(data.projects, function(key, value){
                html += "<div class=\"col-xl-4 col-lg-4 col-md-6 mt-4\">"+
                        "<div class=\"thumbnail text-center\">"+
                            "<div class=\"hover-container\">"+
                                "<div class=\"hover-img\">"+
                                    "<img src=\"/uploads/projects/"+ value.project_image + "\" alt=\""+ value.project_name +"\">"+
                                "</div>"+
                                "<div class=\"icon\">"+
                                    "<a id=\"viewProjectDetailImages\" href=\"#\" class=\"text\" data-id=\"" + value.id + "\" data-toggle=\"modal\" data-target=\"#detailModal\"><i class=\"fas fa-eye\"></i></a>"+
                                "</div>"+
                            "</div>"+
                            "<p class=\"project-name\">"+ value.project_name + "</p>"+
                            "<p class=\"location\"><i class=\"fas fa-map-marker-alt mr-1\"></i>"+ value.project_location +"</p>"+
                        "</div>"+
                        "<div class=\"text-center edlinks mt-2\">"+
                            "<a id=\"editProjectLink\" href=\"\" data-toggle=\"modal\" data-target=\"#editProject\" data-id=\"" + value.id + "\" class=\"mr-2\">Edit</a>"+
                            "<a href=\"/deleteProjects/" + value.id + "\">Delete</a>"+
                        "</div>"+
                    "</div>";
                });
                
                $('#seeMoreLink').data('project_count', data.projects.length);
                $('#seeMoreLink').attr('data-project_count', data.projects.length);

                $('#seeLessLink').data('project_count', data.projects.length);
                $('#seeLessLink').attr('data-project_count', data.projects.length);

                if(data.projects.length == data.total_projects){
                    $('#seeMoreLink').hide();
                    $('#seeLessLink').show();
                }
                else{
                    if(data.projects.length > m){
                        $('#seeMoreLink').show();
                        $('#seeLessLink').show();
                    }
                    if(data.projects.length == m){
                        $('#seeMoreLink').show();
                        $('#seeLessLink').hide();
                    }
                }
                
                $('#projects .row').empty();
                $('#projects .row').html(html);

            });

            if($(window).width() > 991){
                var scrolltoOffset= $('nav').outerHeight() + 50;

                var scrollto = $('#projects').offset().top - scrolltoOffset;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }
            else{
                $('nav #navbarMenu').removeClass('show');

                var scrollto = $('#projects').offset().top - 105;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }


            $('#editProject').modal();
            $('#editProject #formEditProject').attr('action', '/updateProjects/'+ $('#editprojectid1').val());
            $('#editProject #formAddNewDetailImages').attr('action', '/addNewDetailImages/'+ $('#editprojectid1').val());
            $('#editprojectname').val($('#editprojectname1').val());
            $('#editprojectlocation').val($('#editprojectlocation1').val());
            var preview_project_image = "<div class=\"row text-center mb-1\">"+
                                        "<div class=\"col-4 my-2\">"+
                                        "<img src=\"/uploads/projects/"+ $('#editprojectmainimage1').val() + "\" style=\"max-width: 100%; width: auto; height: 100px;\"/>"+
                                        "</div>"+
                                    "</div>";
            $('#editpreviewImage').html(preview_project_image);
        });
    </script>
    @endif 
    
    {{-- Adding Project Successful Message --}}
    @if( session('project_successful_message') )
    <script type="text/javascript">
        $(document).ready(function(){
            $('#content').show();
            $('#loading').hide();
            alert('{{ session('project_successful_message') }}');

            if($(window).width() > 991){
                var scrolltoOffset= $('nav').outerHeight() + 50;

                var scrollto = $('#projects').offset().top - scrolltoOffset;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }
            else{
                $('nav #navbarMenu').removeClass('show');

                var scrollto = $('#projects').offset().top - 105;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }
        });
    </script>
    @endif

    {{-- Updating Project Successful Message --}}
    @if( session('project_update_successful_message') )
    <script type="text/javascript">
        $(document).ready(function(){
            $('#content').show();
            $('#loading').hide();
            alert('{{ session('project_update_successful_message') }}');


            var count= {{session('editprojectcount')}};
            var m = 6;

            $.get('increaseProjects/' + count, function(data){
                var html = "";
                
                $.each(data.projects, function(key, value){
                html += "<div class=\"col-xl-4 col-lg-4 col-md-6 mt-4\">"+
                        "<div class=\"thumbnail text-center\">"+
                            "<div class=\"hover-container\">"+
                                "<div class=\"hover-img\">"+
                                    "<img src=\"/uploads/projects/"+ value.project_image + "\" alt=\""+ value.project_name +"\">"+
                                "</div>"+
                                "<div class=\"icon\">"+
                                    "<a id=\"viewProjectDetailImages\" href=\"#\" class=\"text\" data-id=\"" + value.id + "\" data-toggle=\"modal\" data-target=\"#detailModal\"><i class=\"fas fa-eye\"></i></a>"+
                                "</div>"+
                            "</div>"+
                            "<p class=\"project-name\">"+ value.project_name + "</p>"+
                            "<p class=\"location\"><i class=\"fas fa-map-marker-alt mr-1\"></i>"+ value.project_location +"</p>"+
                        "</div>"+
                        "<div class=\"text-center edlinks mt-2\">"+
                            "<a id=\"editProjectLink\" href=\"\" data-toggle=\"modal\" data-target=\"#editProject\" data-id=\"" + value.id + "\" class=\"mr-2\">Edit</a>"+
                            "<a href=\"/deleteProjects/" + value.id + "\">Delete</a>"+
                        "</div>"+
                    "</div>";
                });
                
                $('#seeMoreLink').data('project_count', data.projects.length);
                $('#seeMoreLink').attr('data-project_count', data.projects.length);

                $('#seeLessLink').data('project_count', data.projects.length);
                $('#seeLessLink').attr('data-project_count', data.projects.length);

                if(data.projects.length == data.total_projects){
                    $('#seeMoreLink').hide();
                    $('#seeLessLink').show();
                }
                else{
                    if(data.projects.length > m){
                        $('#seeMoreLink').show();
                        $('#seeLessLink').show();
                    }
                    if(data.projects.length == m){
                        $('#seeMoreLink').show();
                        $('#seeLessLink').hide();
                    }
                }
                
                $('#projects .row').empty();
                $('#projects .row').html(html);

            });

            if($(window).width() > 991){
                var scrolltoOffset= $('nav').outerHeight() + 50;

                var scrollto = $('#projects').offset().top - scrolltoOffset;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }
            else{
                $('nav #navbarMenu').removeClass('show');

                var scrollto = $('#projects').offset().top - 105;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }

        });
    </script>
    @endif

    {{-- Successful Message --}}
    @if( session('message') )
    <script type="text/javascript">
        $(document).ready(function(){
            alert('{{ session('message') }}');
        });
    </script>
    @endif

    {{-- Contact Us Failed --}}
    @if( session('contact_failed') )
    <script type="text/javascript">
        $(document).ready(function(){
            $('#content').show();
            $('#loading').hide();

            if($(window).width() > 991){
                var scrolltoOffset= $('nav').outerHeight() + 50;

                var scrollto = $('#contact').offset().top - scrolltoOffset;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }
            else{
                $('nav #navbarMenu').removeClass('show');

                var scrolltoOffset= $('nav').outerHeight() + 150;
                var scrollto = $('#contact #formContact').offset().top - scrolltoOffset;

                $('html, body').animate({
                    scrollTop: scrollto
                }, 900);
            }

        });
    </script>
    @endif


    <div id="loading" class="container">
        <div class="loading-container">
            <div id="loading-label" class="loader-label">0%</div>
            <div class="loader"></div>
        </div>
    </div>

    <div id="content">
        <!-- navigation -->
        <!-- <div class="navigation"> -->
        <nav id="navbar" class="navbar navbar-expand-lg fixed-top text-center">
            <div class="container">
                <a href="#">
                    <img src="images/Royal KMK (Logo).png" class="navbar-img"/>
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarMenu">
                    <span class="fas fa-bars"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarMenu">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item dropdown-close">
                            <button type="button" class="nav-link">&times;</button> 
                        </li>
                        <li class="nav-item">
                            <a href="#hero" class="nav-link">Home</a>
                        </li>
                        <li class="nav-item">
                            <a href="#about" class="nav-link">About Us</a>
                        </li>
                        <li class="nav-item">
                            <a href="#services" class="nav-link">Our Services</a>
                        </li>
                        <li class="nav-item">
                            <a href="#projects" class="nav-link">Our Projects</a>
                        </li>
                        <li class="nav-item">
                            <a href="#contact" class="nav-link">Contact Us</a>
                        </li> 

                        @auth
                        <li class="nav-item">
                            <a id="dropdownMenu" href="#" class="nav-link" data-toggle="dropdown"> {{ Auth::user()->name }} <i class="fas fa-caret-down"></i></a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenu">
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#addNewProject"><i class="fas fa-tasks" style="margin-right:14px;"></i>New Project</a>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#profile"><i class="fas fa-user-circle" style="margin-right:14px;"></i>Your Profile</a>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#profileSettings"><i class="fas fa-user-cog"></i>Profile Settings</a>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#changePassword"><i class="fas fa-key" style="margin-right:14px;"></i>Change Password</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{ url('/logout')}}"><i class="fas fa-sign-out-alt"></i>Log Out</a>
                            </div>
                        </li>
                        @endauth

                    </ul>
                </div>
            </div>
        </nav>
        <!-- </div> -->
        
        <!-- Hero -->
        <section id="hero" class="d-flex flex-column justify-content-center">
            <div class="container">
                <div class="row animateUp">
                    <h1>Welcome to Royal Kaung Myat Kyaw Construction Company Limited.,</h1>
                </div>
            </div>
        </section>

        <!-- About Us -->
        <section id="about" class="about">
            <div class="container">
                <div class="title animationUp">
                    <h2>About Us</h2>
                    <p>Royal Kaung Myat Kyaw (RKMK) Construction Company was established since 1995. We have buillt numerous residental buildings, apartments, schools, hospitals, clinics, staff housing, etc. around Myanmar. RKMK consists of a well-exprienced team who have each worked in the field of construction management, decoration and enginnering for a prolonged period. Our team has building and enginnering knowledge, industry knowledge, negotiation, risk management, experience with technology and hand-eye coordination. We provides the best services with tranditional techniques and modern technologies to meet the clients' satisfaction on target schedule and within an agreed budget. </p>
                </div>
                <div class="row content">
                    <div class="col-12 animationLeft pt-4">
                        <h4>Our Mission</h4>
                        <p>&nbsp;&nbsp;Our mission is to build <strong>modern and innovative buildings</strong> and to sell them at <strong>affordable prices</strong> with <strong>the best delivering quality and services</strong> around Myanmar.</p>
                    </div>
                    <div class="col-12 animationRight pt-4">
                        <h4>Our Vision</h4>
                        <p>&nbsp;&nbsp;Our vision is to raise <strong>the living standards</strong> and become <strong>world-class buildings</strong> across Myanmar in the future.</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="services" class="services container text-center">
            <h2 class="animationUp">Services</h2>
            <h4 class="animationUp">We Provide:</h4>
            <div class="row text-center content">
                <div class="col-xl-3 col-lg-3 col-md-6 mt-3 animationLeft">
                    <div class="thumbail">
                        <div class="icon rounded-circle">
                            <i class="fas fa-home"></i>
                        </div>
                        <h3>Construction</h3>
                        <p>Constructions of Residence Buildings, Apartments, Schools, Hotels, Clinics, Staff Housing, etc.</p>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-6 mt-3 animationLeft">
                    <div class="thumbail">
                        <div class="icon rounded-circle">
                            <i class="fas fa-paint-roller"></i>
                        </div>
                        <h3>Home Decoration</h3>
                        <p>Creative Interior Decoration of Custom-made Furniture, Wall Paintings, Lamps, and Other Types of Wooden Products.</p>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-6 mt-3 animationRight">
                    <div class="thumbail">
                        <div class="icon rounded-circle">
                            <i class="fas fa-bolt"></i>
                        </div>
                        <h3>Enginnering</h3>
                        <p>Mechanical and Electrical Works</p>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-6 mt-3 animationRight">
                    <div class="thumbail">
                        <div class="icon rounded-circle">
                            <i class="fas fa-tools"></i>
                        </div>
                        <h3>Maintenance and Servicing</h3>
                        <p>Installation, Design, Estimating, and Repairing </p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Our Projects -->
        <section id="projects" class="projects container">
            <h2 class="animationUp">Our Projects</h2>
            <div class="row animationUp mb-3">
                @if(count($projects) > 0)
                @foreach($projects as $project)
                <div class="col-xl-4 col-lg-4 col-md-6 mt-4">
                    <div class="thumbnail text-center">
                        <div class="hover-container">
                            <div class="hover-img">
                                <img src="{{ asset('uploads/projects/'.$project->project_image) }}" alt="{{ $project->project_name }}">
                            </div>
                            <div class="icon">
                                <a id="viewProjectDetailImages" href="#" class="text" data-id="{{ $project->id }}" data-toggle="modal" data-target="#detailModal"><i class="fas fa-eye"></i></a>
                            </div>
                        </div>
                        <p class="project-name">{{ $project->project_name }}</p>
                        <p class="location"><i class="fas fa-map-marker-alt mr-1"></i>{{ $project->project_location }}</p>
                    </div>
                    @auth
                    <div class="text-center edlinks mt-2">
                        <a id="editProjectLink" href="" data-toggle="modal" data-target="#editProject" data-id="{{ $project->id }}" class="mr-2">Edit</a>
                        <a href="/deleteProjects/{{ $project->id }}">Delete</a>
                    </div>
                    @endauth
                </div>
                @endforeach
                @else
                    <div class="col-12 no-project">
                        <p class="text-center">No projects...</p>
                    </div>
                @endif
            </div>
            @if(count($projects) != $total_projects)
            <div class="mt-5 mx-4 mb-1 text-right">
                <a id="seeMoreLink" href="" class="seeMoreLink" data-project_count="{{ count($projects) }}">See More</a>
                <a id="seeLessLink" href="" class="seeLessLink ml-3" data-project_count="{{ count($projects) }}" style="display: none;">See Less</a>
            </div>
            @endif
        </section>

        <!-- Contact Us -->
        <section id="contact" class="contact container">
            <h2 class="animationUp">Contact Us</h2>
            <div class="row">
                <div class="col-xl-6 col-lg-6 animationLeft">
                    <div class="get-in-touch">
                        <div class="icon"><i class="fas fa-phone-alt"></i></div><div class="text"><p>+959-5154112, +959-965154112, +959-785154112</p></div>
                    </div>
                    <div class="get-in-touch">
                        <div class="icon"><i class="fas fa-envelope-open-text"></i></div><div class="email-address text"><p>info@royalkaungmyatkyaw.com</p></div>
                    </div>
                    <div class="get-in-touch">
                        <div class="icon"><i class="fas fa-map-marker-alt"></i><br/><br/></div><div class="text"><p>No.25, 2<sup>nd</sup> floor, 45<sup>th</sup> Street, Between Marchant Road and Mahabandoola Road, Botahtaung Township, Yangon, Myanmar <br/> (<a href="" data-toggle="modal" data-target="#MapLocation">Get Location</a>)</p></div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 pt-4 pt-xl-0 pt-lg-0 animationRight">
                    <h4>GET IN TOUCH WITH US</h4>
                    <form id="formContact" method="POST" action="/contact-us">
                        @csrf
                        <div class="form-group">
                            <div class="form-input">
                                <input type="text" name="username" id="username" class="form-control" value="{{ old('username') }}" required/>
                                <label alt="Your Name" for="username" placeholder="Your Name">Your Name</label>
                            </div>
                            <div class="form-input-error">
                                @if($errors->has('username'))
                                <label id="username-error" class="error" for="username">{{ $errors->first('username')}} </label>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="form-input">
                                <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}" required/>
                                <label alt="Your Email" for="email" placeholder="Your Email">Your Email</label>
                            </div>
                            <div class="form-input-error">
                                @if($errors->has('email'))
                                <label id="email-error" class="error" for="email">{{ $errors->first('email')}} </label>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="form-input">
                                <textarea rows="5" name="message" id="message" class="form-control" required>{{ old('message') }}</textarea>
                                <label alt="Message" for="message" placeholder="Message">Message</label>
                            </div>
                            <div class="form-input-error">
                                @if($errors->has('message'))
                                <label id="message-error" class="error" for="message">{{ $errors->first('message')}} </label>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <input id="btnSend" type="submit" value="Send" class="btn"/>
                        </div>
                    </form>
                </div>
            </div>
        </section>
   
        <!-- Footer -->
        <footer>
            <a class="back-to-top">
                <i class="fas fa-chevron-up"></i>
            </a>
            <p>Copyright © 2021. All Rights Reserved by Royal Kaung Myat Kyaw Construction Company Limited.,</p>
        </footer>
    </div>

    <!-- Map Location -->
    <div id="MapLocation" class="modal fade" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content" style="background-color: #f6f6f6;">
                <div class="modal-header">
                    <h5 class="modal-title">Location of RKMK Company</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body w-100">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3820.058233772508!2d96.16550531417916!3d16.773778124627746!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMTbCsDQ2JzI1LjYiTiA5NsKwMTAnMDMuNyJF!5e0!3m2!1sen!2sus!4v1624958935302!5m2!1sen!2sus" height="450" frameborder="0" style="width: 100%; border:0;" allowfullscreen="true" aria-hidden="false" tabindex="0"></iframe>
                </div>
            </div>
        </div>
    </div>

    <!-- View Detail -->
    <div class="modal fade" id="detailModal"> 
        <div class="modal-dialog">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">&times;</span>
            </button>
            <div class="modal-content overflow-hidden pt-2 text-center">
                <div id="detail_photo"></div>

                <a class="prev"><i class="fas fa-chevron-left"></i></a>
                <a class="next"><i class="fas fa-chevron-right"></i></a>

                <div class="container small-thumbnail-container pt-3">
                    <div class="row">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add New Project -->
    <div class="modal fade" id="addNewProject" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content" style="background-color: #f6f6f6;">
                <div class="modal-header">
                    <h5 class="modal-title">New Project</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @auth
                    <div class="container">
                        <form id="formAddProject" method="POST" action="{{ url('addNewProject')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="projectname">Project Name</label>
                                <input type="text" id="projectname" name="projectname" value="{{ old('projectname') }}" class="form-control"/>
                                <div class="form-input-error">
                                    @if($errors->has('projectname'))
                                    <label id="projectname-error" class="error" for="projectname">{{ $errors->first('projectname')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <label for="projectlocation">Project Location</label>
                                <input type="text" id="projectlocation" name="projectlocation" value="{{ old('projectlocation') }}" class="form-control"/>
                                <div class="form-input-error">
                                    @if($errors->has('projectlocation'))
                                    <label id="projectlocation-error" class="error" for="projectlocation">{{ $errors->first('projectlocation')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <label>Project Main Image</label>
                                <div id="previewImage"></div>
                                <div id="formfile">
                                    <input type="file" style="opacity: 0; visibility: hidden; width: 0; height: 0;" id="projectmainimage" name="projectmainimage" value="{{ old('projectmainimage') }}" class="form-control" />
                                    <label id="projectimage" for="projectmainimage">Choose an image </label><span id="projectmainimagelength" class="px-3"></span>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('projectmainimage'))
                                    <label id="projectmainimage-error" class="error" for="projectmainimage">{{ $errors->first('projectmainimage')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <label>Project Detail Images</label>
                                <div id="previewDetailImages">
                                    <div class="row text-center"></div>
                                </div>
                                <div id="formfile">
                                    <input type="file" style="opacity: 0; visibility: hidden; width: 0; height: 0;" name="projectdetailimage[]" id="projectdetailimage" class="form-control" multiple="multiple"/>
                                    <label id="projectimage" for="projectdetailimage">Choose the detail images </label><span id="projectdetailimagelength" class="px-3"></span>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('projectdetailimage.*'))
                                    <label id="projectdetailimage-error" class="error" for="projectdetailimage">{{ $errors->first('projectdetailimage.*')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <input id="btnAddProject" type="submit" value="Add" class="btn w-100"/>
                            </div>
                        </form>
                    </div>
                    @endauth
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Project -->
    <div class="modal fade" id="editProject" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-dialog-scrollable">
            <div class="modal-content" style="background-color: #f6f6f6;">
                <div class="modal-header">
                    <h5 class="modal-title">Editing Project</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @auth
                    <div class="container">
                        <!-- Edit Project  -->
                        <form id="formEditProject" class="pb-2" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" id="editprojectcount" name="editprojectcount" class="form-control"/>
                            <input type="hidden" id="editprojectid" name="projectid" value="{{ old('projectid') }}" class="form-control"/>
                            <div class="form-group">
                                <label for="editprojectname">Project Name</label>
                                <input type="text" id="editprojectname" name="editprojectname" class="form-control" value="{{ old('editprojectname') }}"/>
                                <div class="form-input-error">
                                    @if($errors->has('editprojectname'))
                                    <label id="editprojectname-error" class="error" for="editprojectname">{{ $errors->first('editprojectname')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <label for="editprojectlocation">Project Location</label>
                                <input type="text" id="editprojectlocation" name="editprojectlocation" class="form-control" value="{{ old('editprojectlocation') }}"/>
                                <div class="form-input-error">
                                    @if($errors->has('editprojectlocation'))
                                    <label id="editprojectlocation-error" class="error" for="editprojectlocation">{{ $errors->first('editprojectlocation')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <label>Project Main Image</label>
                                <div id="editpreviewImage"></div>
                                <div id="formfile">
                                    <input type="file" id="editprojectmainimage" name="editprojectmainimage" class="form-control" value="{{ old('editprojectmainimage') }}"/>
                                    <label id="projectimage" for="editprojectmainimage">Choose an image </label><span id="editprojectmainimagelength" class="px-3"></span>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('editprojectmainimage'))
                                    <label id="editprojectmainimage-error" class="error" for="editprojectmainimage">{{ $errors->first('editprojectmainimage')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <input id="btnEditProject" type="submit" value="Edit" class="btn w-100"/>
                            </div>
                        </form>

                        <!-- Add New Detail Images -->
                        <form id="formAddNewDetailImages" class="py-3" method="POST" enctype="multipart/form-data">
                            @csrf
                            <h5 class="mb-3 text-center">Adding New Detail Images</h5>
                            <input type="hidden" id="editprojectcount1" name="editprojectcount1" class="form-control"/>
                            <input type="hidden" id="editprojectid1" name="editprojectid1" value="{{ old('editprojectid1') }}"/>
                            <input type="hidden" id="editprojectname1" name="editprojectname1" value="{{ old('editprojectname1') }}"/>
                            <input type="hidden" id="editprojectlocation1" name="editprojectlocation1" value="{{ old('editprojectlocation1') }}"/>
                            <input type="hidden" id="editprojectmainimage1" name="editprojectmainimage1" value="{{ old('editprojectmainimage1') }}"/>
                            {{-- <input type="hidden" id="editprojectdetailimage1" name="editprojectdetailimage1" value="{{ old('editprojectdetailimage1') }}"/> --}}
                            <div class="form-group">
                                <label>Project Detail Images</label>
                                <div id="editpreviewDetailImages">
                                    <div class="row"></div>
                                </div>
                                <div id="formfile">
                                    <input type="file" style="opacity: 0; visibility: hidden; width: 0; height: 0;" name="editprojectdetailimage[]" id="editprojectdetailimage" class="form-control" multiple="multiple"/>
                                    <label id="projectimage" for="editprojectdetailimage">Choose the detail images </label><span id="editprojectdetailimagelength" class="px-2"></span>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('editprojectdetailimage'))
                                    <label id="editprojectdetailimage-error" class="error" for="editprojectdetailimage">{{ $errors->first('editprojectdetailimage')}} </label>
                                    @endif
                                    @if($errors->has('editprojectdetailimage.*'))
                                    <label id="editprojectdetailimage-error" class="error" for="editprojectdetailimage">{{ $errors->first('editprojectdetailimage.*')}} </label>
                                    @endif
                                </div> 
                            </div>

                            <div class="form-group">
                                <input id="btnAddNewDetailImages" type="submit" value="Add New Detail Images" class="btn w-100"/>
                            </div>
                        </form>

                        <!-- Show Detail Images -->
                        <div id="showDetailImages" class="my-3 text-center">
                            <h5 class="my-3">Project Detail Images</h5>
                            <div class="row">   
                                @if(session('editprojectdetailimage'))
                                    @foreach(session('editprojectdetailimage') as $detailimage)
                                    <div class="col-4 my-2">
                                        <img src="/uploads/projects_detail/{{$detailimage->project_detail_images}}" style="max-width: 100%; width: auto; height: 100px;">
                                        <div class="mt-2">
                                            <a id="deleteProjectDetailImageLink" href="#" data-id="{{$detailimage->project_detail_id}}" data-project_id="{{$detailimage->project_id}}">Delete</a>
                                        </div>
                                    </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                    @endauth
                </div>
            </div>
        </div>
    </div>

    <!-- Profile -->
    <div class="modal fade" id="profile" data-backdrop="static" data-keyboard="false" style="top:17%;">
        <div class="modal-dialog">
            <div class="modal-content" style="background-color: #f6f6f6;">
                <div class="modal-header">
                    <h5 class="modal-title">Your Profile</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @auth
                    <div class="container">
                        <div class="row py-3">
                            <div class="col-4 title">
                                Your ID Number:
                            </div>
                            <div class="col-8 ans">
                                {{ Auth::user()->id }}
                            </div>
                        </div>
                        <div class="row py-3">
                            <div class="col-4 title">
                                Your Name:
                            </div>
                            <div class="col-8 ans">
                                {{ Auth::user()->name }}
                            </div>
                        </div>
                        <div class="row py-3">
                            <div class="col-4 title">
                                Your Email:
                            </div>
                            <div class="col-8 ans">
                                {{ Auth::user()->email }}
                            </div>
                        </div>
                        <div class="row py-3">
                            <div class="col-4 title">
                                Registered Date:
                            </div>
                            <div class="col-8 ans">
                                {{ Auth::user()->created_at->format('d M Y') }}
                            </div>
                        </div>
                    </div>
                    @endauth
                </div>
            </div>
        </div>
    </div>

    <!-- Profile Settings -->
    <div class="modal fade" id="profileSettings" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content" style="background-color: #f6f6f6;">
                <div class="modal-header">
                    <h5 class="modal-title">Profile Settings</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    @auth
                    <div class="container">
                        <form id="formProfileSetting" method="POST" action="{{ url('/profileSettings') }}">
                            @csrf
                            <div class="form-group">
                                <label for="userid">Your ID Number:</label>
                                <input type="text" id="userid" name="userid" value="{{  old('userid') }}" class="form-control" readonly/>
                            </div>
                            <div class="form-group">
                                <label for="username">Your Name:</label>
                                <input type="text" id="username1" name="username" value="{{  old('username') }}" class="form-control"/>
                                <div class="form-input-error">
                                    @if($errors->has('username'))
                                    <label id="username-error" class="error" for="username">{{ $errors->first('username')}} </label>
                                    @endif
                                </div>        
                            </div>
                            <div class="form-group">
                                <label for="useremail">Your Email:</label>
                                <input type="email" id="useremail" name="useremail" value="{{ old('useremail') }}" class="form-control"/>
                                <div class="form-input-error">
                                    @if($errors->has('useremail'))
                                    <label id="useremail-error" class="error" for="useremail">{{ $errors->first('useremail')}} </label>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="registereddate">Registered Date:</label>
                                <input type="text" id="registereddate" name="registereddate" value="{{ old('registereddate') }}" class="form-control" readonly/>
                            </div>
                            <div class="form-group">
                                <input id="btnEditProfile" type="submit" value="Edit Profile" class="btn w-100 mb-3"/>
                                <input id="btnChangePass" type="button" value="Change Your Password" data-toggle="modal" data-target="#changePassword" class="btn w-100"/>
                            </div>
                        </form>
                    </div>
                    @endauth
                </div>
            </div>
        </div>
    </div>

    <!-- Change Password -->
    <div class="modal fade" id="changePassword" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content" style="background-color: #f6f6f6;">
                <div class="modal-header">
                    <h5 class="modal-title">Change Password</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container">
                        <form id="formChangePassword" method="POST" action="{{ url('/changePassword') }}">
                            @csrf
                            <div class="form-group position-relative">
                                <label for="userpassword">Current Password:</label>
                                <input type="password" id="userpassword" name="userpassword" value="{{ old('userpassword')}}" class="form-control" autocomplete="current-password"/>
                                <div class="passwordToggle">
                                    <i id="passwordVisibility" class="fas fa-eye"></i>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('userpassword'))
                                    <label id="userpassword-error" class="error" for="userpassword">{{ $errors->first('userpassword')}} </label>
                                    @endif
                                    @if(session('wrong_password'))
                                    <label id="userpassword-error" class="error" for="userpassword">{{ session('wrong_password')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group position-relative">
                                <label for="newpassoword">New Password:</label>
                                <input type="password" id="newpassoword" name="newpassoword" value="{{ old('newpassoword')}}" class="form-control" autocomplete="new-password"/>
                                <div class="passwordToggle">
                                    <i id="passwordVisibility" class="fas fa-eye"></i>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('newpassoword'))
                                    <label id="newpassoword-error" class="error" for="newpassoword">{{ $errors->first('newpassoword')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group position-relative">
                                <label for="confirmpassoword">Confirmed Password:</label>
                                <input type="password" id="confirmpassoword" name="confirmpassoword" value="{{ old('confirmpassoword')}}" class="form-control" autocomplete="new-password"/>
                                <div class="passwordToggle">
                                    <i id="passwordVisibility" class="fas fa-eye"></i>
                                </div>
                                <div class="form-input-error">
                                    @if($errors->has('confirmpassoword'))
                                    <label id="confirmpassoword-error" class="error" for="confirmpassoword">{{ $errors->first('confirmpassoword')}} </label>
                                    @endif
                                </div> 
                            </div>
                            <div class="form-group">
                                <input id="btnChangePassword" type="submit" value="Change Password" class="btn w-100"/>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
</html>

