$(document).ready(function(){
    $('#btnChangePassword').on('click', function(){
        $('#formChangePassword').validate({
            rules: {
                "userpassword": {
                    required: true,
                },
                "newpassoword": {
                    required: true,
                    minlength: 6
                },
                "confirmpassoword": {
                    required: true,
                    equalTo: "#newpassoword"
                }
            },
            messages: {
                "userpassword": { 
                    required: "Please enter the current password."
                },
                "newpassoword": { 
                    required: "Please enter the new password.",
                    minength: "Your new password must be at least 6 characters."
                },
                "confirmpassoword": { 
                    required: "Please enter the confirmed password.",
                    equalTo: "The confirmed password must be equal to the new password."
                }
            },
            errorPlacement: function(error, element){
                error.insertAfter(element);                            
            },
            highlight: function(element){
                $(element).addClass('input-validation-error');
                $(element).parents('.form-group').attr('style', 'margin-bottom:9px;'); 
            },
            unhighlight: function(element){
                $(element).removeClass('input-validation-error');
                $(element).parents('.form-group').removeAttr('style');
            }
        });
    });

    $.validator.addMethod("checkEmail", function(value, element){
        return /^[\w -.]+@[\w -.]+\.\w{2,}$/.test(value);
    }, "Invalid email address!!!");

    $('#changePassword .close').click(function () {
        $('#changePassword .form-control').val('');
        $("#changePassword #formChangePassword .form-input-error").each(function() {
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
            $(this).empty();
        });
        $("#changePassword #formChangePassword .error").each(function(){
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error').removeAttr('aria-invalid');
            $(this).parents('.form-group').removeAttr('style');
            $(this).remove();
        });
    });

     // For Laravel Error
     $("#formChangePassword .form-input-error").each(function() {       
        if($(this).children().hasClass('error')) {  
            $(this).parents('.form-group').find('.form-control').addClass('input-validation-error');    
            $(this).parents('.form-group').attr('style', 'margin-bottom:10px;'); 
            $(this).attr('style', 'margin-top:4px;'); 
        } 
        else{
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
        } 
    });
});