$(document).ready(function(){
    $('#btnSend').on('click', function(){
        $('#formContact').validate({
            rules: {
                "username": {
                    required: true
                },
                "email": {
                    required: true,
                    checkEmail: true
                },
                "message": {
                    required: true
                }
            },
            messages: {
                "username": {
                    required: "Please enter your name."
                },
                "email": {
                    required: "Please enter your email.",
                    checkEmail: "Please enter a valid email address."
                },
                "message": { 
                    required: "Please enter your message."
                }
            },
            errorPlacement: function(error, element){
                error.appendTo(element.parents('.form-input').next('.form-input-error'));                            
            },
            highlight: function(element){
                $(element).addClass('input-validation-error');
                $(element).parents('.form-group').attr('style', 'margin-bottom:20px;'); 
            },
            unhighlight: function(element){
                $(element).removeClass('input-validation-error');
                $(element).parents('.form-group').removeAttr('style');
            }
        });
    });

    $('#formContact input, #formContact textarea').blur(function(){
        if($(this).val() != ''){
            $(this).addClass('form-control-error');
        }   
        else{
            $(this).removeClass('form-control-error');
        }
    });

    $.validator.addMethod("checkEmail", function(value, element){
        return /^[\w -.]+@[\w -.]+\.\w{2,}$/.test(value);
    }, "Invalid email address!!!");

    $("#formContact .form-input-error").each(function() {       
        if($(this).children().hasClass('error')) {  
            $(this).parents('.form-group').find('.form-control').addClass('input-validation-error');        
            $(this).parents('.form-group').attr('style', 'margin-bottom:20px;'); 
            $(this).attr('style', 'margin-top:2px;'); 
        } 
        else{
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
        } 
    });
});