$(document).ready(function(){

    $('body').on('click', '[id*=editProjectLink]', function(e){
        e.preventDefault();
        $('#editProject #formEditProject .form-control').val('');
        $('#editProject #showDetailImages .row').empty();

        var id = $(this).data('id');

        $.get('updateProjects/' + id, function(data){
            $('#editprojectid').val(id);
            $('#editprojectname').val(data.projects.project_name);
            $('#editprojectlocation').val(data.projects.project_location);
            //$('#editprojectmainimage').val(data.projects.project_image);
            $('#editprojectid1').val(data.projects.id);
            $('#editprojectname1').val($('#editprojectname').val());
            $('#editprojectlocation1').val($('#editprojectlocation').val());
            $('#editprojectmainimage1').val(data.projects.project_image);

            var preview_project_image = "<div class=\"row text-center mb-1\">"+
                                        "<div class=\"col-4 my-2\">"+
                                        "<img src=\"/uploads/projects/"+ data.projects.project_image + "\" style=\"max-width: 100%; width: auto; height: 100px;\"/>"+
                                        "</div>"+
                                    "</div>";
            $('#editpreviewImage').html(preview_project_image);

            var show_projects_detail= "";
            
            if(data.projects_detail_count != 0){
                $.each(data.projects_detail, function(key, value){
                    show_projects_detail += "<div class=\"col-4 my-2\">"+
                                "<img src=\"/uploads/projects_detail/"+ value.project_detail_images + "\" style=\"max-width: 100%; width: auto; height: 100px;\">"+
                                "<div class=\"mt-2\">" +
                                    "<a id=\"deleteProjectDetailImageLink\" href=\"#\" data-id=\""+value.project_detail_id+"\" data-project_id=\""+data.projects.id+"\">Delete</a>"+
                                "</div>"+
                            "</div>";
                
                });
            }
            else{
                show_projects_detail +=  "<div class=\"col-12 my-5\">"+
                            "<p style=\"color:red; font-size:13px;\" class=\"text-center font-weight-bold\">No detail images...</p>"+
                            "</div>";
            }

            $('#editProject #showDetailImages .row').append(show_projects_detail);
            $('#editProject #formEditProject').attr('action', '/updateProjects/'+ data.projects.id);
            $('#editProject #formAddNewDetailImages').attr('action', '/addNewDetailImages/'+ data.projects.id);
            $('#editProject').modal();
        });
    });

    $('#editProject #btnEditProject').on('click', function(){
        var noOfprojects = $('#projects .thumbnail').length;
        $('#editProject #editprojectcount').val(noOfprojects);
        $('#editProject #editprojectcount1').val(noOfprojects);
        
        $('#editProject label#editprojectmainimage-error.error:first').remove();
        
        $('#editProject #formEditProject').validate({
            rules: {
                "editprojectname": {
                    required: true,
                    maxlength: 30
                },
                "editprojectlocation": {
                    required: true,
                    maxlength: 20
                },
                "editprojectmainimage": {
                    //required: true,
                    extension: "jpg|jpeg|jpe|jiff|jif|jfif|png"
                }
            },
            messages: {
                "editprojectname": {
                    required: "Please enter the project's name.",
                    maxlength: "The project's name must not be more than 30 characters."
                },
                "editprojectlocation": {
                    required: "Please enter the project's location.",
                    maxlength: "The project's location must not be more than 20 characters."
                },
                "editprojectmainimage": {
                    //required: "Please choose the project's main image.",
                    extension: "The project's main image must be the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png."
                }
            },
            errorPlacement: function(error, element){
                if($(element).attr('type') == "file"){
                    error.appendTo(element.parents('.form-group').before());
                }
                else{
                    error.insertAfter(element);
                }                            
            },
            highlight: function(element){
                if($(element).attr('type') == "file"){
                    $(element).parents('.form-group').attr('style', 'margin-bottom:16px;'); 
                }
                else{
                    $(element).addClass('input-validation-error');
                    $(element).parents('.form-group').attr('style', 'margin-bottom:9px;'); 
                }
            },
            unhighlight: function(element){
                $(element).removeClass('input-validation-error');
                $(element).parents('.form-group').removeAttr('style');
            }
        });
    });

    $('#editProject #btnAddNewDetailImages').on('click', function(){
        var noOfprojects = $('#projects .thumbnail').length;
        $('#editProject #editprojectcount').val(noOfprojects);
        $('#editProject #editprojectcount1').val(noOfprojects);
        
        $('#editprojectid1').val($('#editprojectid').val());
        $('#editprojectname1').val($('#editprojectname').val());
        $('#editprojectlocation1').val($('#editprojectlocation').val());
        $('#editProject label#editprojectdetailimage-error.error:first').remove();
        
        $('#editProject #formAddNewDetailImages').validate({
            rules: {
                "editprojectdetailimage[]": {
                    required: true,
                    extension: "jpg|jpeg|jpe|jiff|jif|jfif|png"
                }
            },
            messages: {
                "editprojectdetailimage[]": {
                    required: "Please choose the project's detail images.",
                    extension: "The project's detail images must be the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png."
                }
            },
            errorPlacement: function(error, element){
                error.appendTo(element.parents('.form-group').before());                         
            },
            highlight: function(element){
                $(element).parents('.form-group').attr('style', 'margin-bottom:16px;'); 
            },
            unhighlight: function(element){
                $(element).parents('.form-group').removeAttr('style');
            }
        });
    });

    $('#editProject .close').on('click', function () {
        $('#editProject .form-control').val('');
        $('#editProject #editprojectmainimagelength, #editProject #editprojectdetailimagelength').text('');
        $('#editProject #editpreviewImage, #editProject #editpreviewDetailImages .row, #editProject #showDetailImages .row').empty();
        $("#editProject #formEditProject .form-input-error, #editProject #formAddNewDetailImages .form-input-error").each(function() {
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
            $(this).empty();
        });
        $("#editProject #formEditProject .error, #editProject #formAddNewDetailImages .error").each(function(){
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error').removeAttr('aria-invalid');
            $(this).parents('.form-group').removeAttr('style');
            $(this).remove();
        });
    });

     // For Laravel Error
    $("#formEditProject .form-input-error, #formAddNewDetailImages .form-input-error").each(function() {       
        if($(this).children().hasClass('error')) { 
            if( $(this).parents('.form-group').find('.form-control').attr('type') == "file"){
                $(this).parents('.form-group').attr('style', 'margin-bottom:16px;'); 
                $(this).attr('style', 'margin-top:4px;'); 
            } 
            else{
                $(this).parents('.form-group').find('.form-control').addClass('input-validation-error');    
                $(this).parents('.form-group').attr('style', 'margin-bottom:10px;'); 
                $(this).attr('style', 'margin-top:4px;'); 
            }
        } 
        else{
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
        } 
    });

});