$(document).ready(function(){
    $('#btnLogin').on('click', function(){
        $('#formLogin').validate({
            rules: {
                "email": {
                    required: true,
                    checkEmail: true
                },
                "password": {
                    required: true
                }
            },
            messages: {
                "email": {
                    required: "Please enter your email.",
                    checkEmail: "Please enter a valid email address."
                },
                "password": { 
                    required: "Please enter your password."
                }
            },
            errorPlacement: function(error, element){
                error.appendTo(element.parents('.form-input').next('.form-input-error'));                            
            },
            highlight: function(element){
                $(element).addClass('input-validation-error');
                $(element).parents('.form-group').attr('style', 'margin-bottom:20px;'); 
            },
            unhighlight: function(element){
                $(element).removeClass('input-validation-error');
                $(element).parents('.form-group').removeAttr('style');
            }
        });
    });

    $('#formLogin input').blur(function(){
        if($(this).val() != ''){
            $(this).addClass('form-control-error');
        }   
        else{
            $(this).removeClass('form-control-error');
        }
    });

    $.validator.addMethod("checkEmail", function(value, element){
        return /^[\w -.]+@[\w -.]+\.\w{2,}$/.test(value);
    }, "Invalid email address!!!");

    //For laravel
    $("#formLogin .form-input-error").each(function() {       
        if($(this).children().hasClass('error')) {  
            $(this).parents('.form-group').find('.form-control').addClass('input-validation-error');        
            $(this).parents('.form-group').attr('style', 'margin-bottom:20px;'); 
            $(this).attr('style', 'margin-top:2px;'); 
        } 
        else{
            $(this).parents('.form-group').find('.form-control').removeClass('input-validation-error');
            $(this).parents('.form-group').removeAttr('style');
            $(this).removeAttr('style');
        } 
    });
});