$(document).ready(function () {

    // Add New Project
    $('#addNewProject #projectmainimage').change(function () {
        $('#addNewProject #previewImage').empty();
        $('#addNewProject #projectmainimagelength').text('');
        $('#addNewProject #projectmainimage-error').remove();

        if (this.files && this.files[0]) {
            var current_extension = $(this).val().split('.').pop().toLowerCase();
            var allowed_extension = new Array('jpg', 'jpeg', 'jpe', 'jiff', 'jif', 'jfif', 'png');

            if ($.inArray(current_extension, allowed_extension) == -1) {
                $(this).parents('#formfile').after('<label id="projectmainimage-error" class="error" for="projectmainimage">The project\'s main image with ' + $(this).val().split('\\').pop() + ' must not be matched the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png.</label>');
                $(this).val('');
            }
            else {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('<div class="row text-center mb-1"><div class="col-4 my-2"><img src="' + e.target.result + '" style="max-width: 100%; width: auto; height: 100px;"/></div><div>').appendTo('#addNewProject #previewImage');
                }
                reader.readAsDataURL(this.files[0]);
                $('#addNewProject #projectmainimagelength').text('A image is selected.');
            }
        }
    });

    $('#addNewProject #projectdetailimage').change(function () {
        $('#addNewProject #previewDetailImages .row').empty();
        $('#addNewProject #projectdetailimagelength').text('');
        $('#addNewProject #projectdetailimage-error').remove();

        if (this.files && this.files[0]) {
        var numoffiles = this.files.length;

        var i;
        var data = [];

            for (i = 0; i < numoffiles; i++) {
                var reader = new FileReader();
                var current_extension = this.files.item(i).name.split('.').pop().toLowerCase();
                var allowed_extension = new Array('jpg', 'jpeg', 'jpe', 'jiff', 'jif', 'jfif', 'png');

                if ($.inArray(current_extension, allowed_extension) == -1) {
                    data.push(this.files.item(i).name);
                }
            }

            if (data.length > 0) {
                var last_word = data[data.length - 1];

                var j;
                var ans = "";
                for (j = 0; j < data.length; j++) {
                    if (data.length == 1) {
                        ans = data[j];
                    }
                    else {
                        if (data[j] != last_word) {
                            ans += data[j] + ", ";
                        }
                        else {
                            ans = ans.slice(0, -2);
                            ans += " and " + last_word;
                        }
                    }
                }

                $(this).parents('#formfile').after('<label id="projectdetailimage-error" class="error" for="projectmainimage">The project\'s detail images with ' + ans + ' must not be matched the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png.</label>');
                $(this).val('');
                data = [];
            }
            else {
                var k;

                for (k = 0; k < numoffiles; k++) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('<div class="col-4 mb-4"><img src="' + e.target.result + '" style="max-width: 100%; width: auto; height: 100px;"/><div>').appendTo('#addNewProject #previewDetailImages .row');
                    }
                    reader.readAsDataURL(this.files[k]);
                }
                
                $('#addNewProject #projectdetailimagelength').text(numoffiles + ' image/s are selected.');
            }
        }
    });

    // Edit Project
    $('#editProject #editprojectmainimage').change(function () {
        $('#editProject #editpreviewImage').empty();
        $('#editProject #editprojectmainimagelength').text('');
        $('#editProject #editprojectmainimage-error').remove();

        if (this.files && this.files[0]) {
            var current_extension = $(this).val().split('.').pop().toLowerCase();
            var allowed_extension = new Array('jpg', 'jpeg', 'jpe', 'jiff', 'jif', 'jfif', 'png');

            if ($.inArray(current_extension, allowed_extension) == -1) {
                $(this).parents('#formfile').after('<label id="editprojectmainimage-error" class="error" for="projectmainimage">The project\'s main image with ' + $(this).val().split('\\').pop() + ' must not be matched the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png.</label>');
                $(this).val('');
            }
            else {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('<div class="row text-center mb-1"><div class="col-4 my-2"><img src="' + e.target.result + '" style="max-width: 100%; width: auto; height: 100px;"/></div><div>').appendTo('#editProject #editpreviewImage');
                }
                reader.readAsDataURL(this.files[0]);
                $('#editProject #editprojectmainimagelength').text('A image is selected.');
            }
        }
    });

    $('#editProject #editprojectdetailimage').change(function () {
        $('#editProject #editpreviewDetailImages .row').empty();
        $('#editProject #editprojectdetailimagelength').text('');
        $('#editProject #editprojectdetailimage-error').remove();
        
        if (this.files && this.files[0]) {
        var numoffiles = this.files.length;

        var i;
        var data = [];

            for (i = 0; i < numoffiles; i++) {
                var reader = new FileReader();
                var current_extension = this.files.item(i).name.split('.').pop().toLowerCase();
                var allowed_extension = new Array('jpg', 'jpeg', 'jpe', 'jiff', 'jif', 'jfif', 'png');

                if ($.inArray(current_extension, allowed_extension) == -1) {
                    data.push(this.files.item(i).name);
                }
            }

            if (data.length > 0) {
                var last_word = data[data.length - 1];

                var j;
                var ans = "";
                for (j = 0; j < data.length; j++) {
                    if (data.length == 1) {
                        ans = data[j];
                    }
                    else {
                        if (data[j] != last_word) {
                            ans += data[j] + ", ";
                        }
                        else {
                            ans = ans.slice(0, -2);
                            ans += " and " + last_word;
                        }
                    }
                }

                $(this).parents('#formfile').after('<label id="editprojectdetailimage-error" class="error" for="projectmainimage">The project\'s detail images with ' + ans + ' must not be matched the extensions of .jpg, .jpeg, .jpe, .jiff, .jif, .jfif or .png.</label>');
                $(this).val('');
                data = [];
            }
            else {
                var k;

                for (k = 0; k < numoffiles; k++) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        $('<div class="col-4 mb-4"><img src="' + e.target.result + '" style="max-width: 100%; width: auto; height: 100px;"/><div>').appendTo('#editProject #editpreviewDetailImages .row');
                    }
                    reader.readAsDataURL(this.files[k]);
                }
                
                $('#editProject #editprojectdetailimagelength').text(numoffiles + ' image/s are selected.');
            }
        }
    });
});