<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Mail;

class ContactController extends Controller
{
    public function sendMail(Request $request){
        $validator = Validator::make($request->all(), [
            'username'=> 'required|max:30',
            'email' => 'required|email',
            'message' => 'required'
            ], [
            'required' => 'Please enter your :attribute.',
            'message.required' => 'Please enter the message.'
            ], [
           'username' => 'name',
           'email' => 'email'
        ]);

        if($validator->fails()){
            return back()->withErrors($validator)->withInput()->with('contact_failed', 'contact_failed');
        }

        \Mail::send(['text'=>'mail'],
	    array(
	        'name' => request()->username, 
	        'email' => request()->email,
	        'user_message' => request()->message
	    ), function($message)
	        	{
	          	$message->from(request()->email, request()->username);
	          	$message->to('info@royalkaungmyatkyaw.com', 'Royal Kaung Myat Kyaw Construction')->subject('Customer Enquiry Form');
	        	});

    	return redirect('/')->with('message', 'Thank you for contact us!!');
    }
}