<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
     <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to RKMK</title>
    <link rel="icon" type="image/png" href="{{ url('images/Royal KMK (Logo).png') }}"/>

    <!-- css -->
    <link rel="stylesheet" href="{{ asset('css/style.css')}} " />
    <link rel="stylesheet" href="{{ asset('css/responsive.css') }}"/>
    <link rel="stylesheet" href="{{ asset('css/loading.css') }}" />
    <link rel="stylesheet" href="{{ asset('bootstrap/dist/css/bootstrap.min.css') }}" />
  
    <!-- animation css -->
    <link rel="stylesheet" href="{{ asset('css/animate.css') }}"/>

    <!-- jquery -->
    <script type="text/javascript" src="{{ asset('jquery-3.5.1/jquery-3.5.1.js') }}"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.2/jquery.validate.min.js"></script>

    <!-- javascript -->
    <script type="text/javascript" src="{{ asset('bootstrap/dist/js/bootstrap.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/main.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/loading.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/passwordToggle.js') }}"></script>
    <script type="text/javascript" src="{{ asset('javascript/LoginValidation.js') }}"></script>


    <!-- font -->
    <!-- <link href="https://fonts.googleapis.com/css2?family=Frank+Ruhl+Libre:wght@300&display=swap" rel="stylesheet"> -->
    <link href="https://fonts.googleapis.com/css2?family=Cabin&display=swap" rel="stylesheet">

    <!-- font awesome -->
    <link rel="stylesheet" href="{{ asset('fontawesome/css/all.css') }}"/>

    <!-- For Body -->
    <style>
        body {
            padding:0;
            margin:0;
            font-family: 'Frank Ruhl Libre', serif;
            color:#333;
            background-color: #f6f6f6;
        }
    </style>

</head>
<body>
    <div id="loading" class="container">
        <div class="loading-container">
            <div id="loading-label" class="loader-label">0%</div>
            <div class="loader"></div>
        </div>
    </div>

    <div id="content" class="login-form">
       <div class="container">
        <div class="logo">
            <img src="images/Royal KMK (Login Logo).png" class="logo-image"/>
        </div>
        <h2>Welcome to RKMK Company</h2>
        <form id="formLogin" method="POST" action="{{ route('login') }}">
            @csrf
            <div class="form-group">
                <div class="form-input">
                    <input type="email" id="email" name="email" value="{{ old('email') }}" class="form-control" required/>
                    <label for="email">Email</label>
                </div>
                <div class="form-input-error">
                    @if ($errors->has('email'))
                        <label class="error">{{ $errors->first('email') }}</label>
                    @endif
                    @if (session('failed'))
                        <label class="error">{{ session('failed') }}</strong>
                    @endif
                </div>
                               
            </div>
            <div class="form-group">
                <div class="form-input">
                    <input type="password" id="password" name="password" class="form-control" required/>
                    <label for="password">Password</label>
                    <div class="passwordToggle">
                        <i id="passwordVisibility" class="fas fa-eye"></i>
                    </div>
                </div>
                <div class="form-input-error">
                    @if ($errors->has('password'))
                        <label class="error">{{ $errors->first('password') }}</label>
                    @endif
                </div>
                
            </div>
            <div class="form-group">
                <input id="btnLogin" type="submit" value="Login" class="btn w-100"/>
            </div>
        </form>
       </div>
    </div>
</body>
</html>