<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Auth::routes();

Route::get('/', 'HomeController@index');
Route::get('/index', 'HomeController@index')->name('index');
Route::get('/increaseProjects/{count}', 'HomeController@increaseProjects');
Route::get('/decreaseProjects/{count}', 'HomeController@decreaseProjects');

Route::post('/login', 'Auth\LoginController@login')->name('login'); 
Route::get('/logout', 'Auth\LoginController@logout');

// User
Route::post('/profileSettings', 'UserController@update'); 
Route::post('/changePassword', 'UserController@updatePassword'); 

// Projects
Route::post('/addNewProject', 'ProjectController@store');
Route::get('/viewProjectDetail/{id}', 'ProjectController@viewProjectDetail')->name('viewProjectDetail');
Route::get('/updateProjects/{id}', 'ProjectController@viewUpdateData');
Route::post('/updateProjects/{id}', 'ProjectController@update');
Route::get('/deleteProjects/{id}', 'ProjectController@delete');

// ProjectDetail
Route::post('/addNewDetailImages/{id}', 'ProjectDetailController@add');
Route::get('/deleteDetailImages/{id}/{project_id}', 'ProjectDetailController@delete');

// Contact Us
Route::post('/contact-us', 'ContactController@sendMail');
